# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' EMMA helper functions
#'
#' Helper functions for computing REML estimates of genetic and residual
#' variance components using the EMMA algorithm.
#'
#' @inheritParams EMMA
#' @param x a q x n covariate matrix, q being the number of covariates and n
#' being the number of genotypes. q has to be at least one (typically an
#' intercept).
#'
#' @noRd
#' @keywords internal
emmaEigenR <- function(k, x, eigVals, eigVecs) {
    invisible(.Call(`_statgenGWAS_emmaEigenR`, k, x, eigVals, eigVecs))
}

emmaREMLLL <- function(logDelta, lambda, etas1, n, t, etas2) {
    .Call(`_statgenGWAS_emmaREMLLL`, logDelta, lambda, etas1, n, t, etas2)
}

goldenSectionSearch <- function(upperBound, center, lowerBound, absolutePrecision, lambda, etas1, n, t, etas2) {
    .Call(`_statgenGWAS_goldenSectionSearch`, upperBound, center, lowerBound, absolutePrecision, lambda, etas1, n, t, etas2)
}

emmaCPP <- function(y, k, x, nGrids = 100L, uLim = 10, lLim = -10, eps = 1e-3) {
    .Call(`_statgenGWAS_emmaCPP`, y, k, x, nGrids, uLim, lLim, eps)
}

codeCharMarkers <- function(markers, refAlls, minor, nCores = NULL) {
    .Call(`_statgenGWAS_codeCharMarkers`, markers, refAlls, minor, nCores)
}

fastGLSCPP <- function(X, y, sigma, size_param = NULL, nCores = NULL) {
    .Call(`_statgenGWAS_fastGLSCPP`, X, y, sigma, size_param, nCores)
}

getThr <- function(nCores = NULL) {
    .Call(`_statgenGWAS_getThr`, nCores)
}

astleCPP <- function(x, MAF = NULL, denom = NULL) {
    .Call(`_statgenGWAS_astleCPP`, x, MAF, denom)
}

IBSCPP <- function(x, MAF = NULL, denom = NULL) {
    .Call(`_statgenGWAS_IBSCPP`, x, MAF, denom)
}

vanRadenCPP <- function(x, MAF = NULL, denom = NULL) {
    .Call(`_statgenGWAS_vanRadenCPP`, x, MAF, denom)
}

#' Reduce the kinship matrix
#'
#' The kinship matrix is reduced using nPca eigenvectors of K.
#'
#' @inheritParams runSingleTraitGwas
#'
#' @param nPca An integer, the number of eigenvectors used for reducing the
#' kinship matrix.
#'
#' @returns The reduced kinship matrix
#'
#' @noRd
#' @keywords internal
reduceKinship <- function(K, nPca) {
    .Call(`_statgenGWAS_reduceKinship`, K, nPca)
}

nearestPD <- function(x, corr = FALSE, keepDiag = FALSE, do2eigen = TRUE, doSym = FALSE, doDykstra = TRUE, eigTol = 1e-6, convTol = 1e-7, posdTol = 1e-8, maxIter = 100L) {
    .Call(`_statgenGWAS_nearestPD`, x, corr, keepDiag, do2eigen, doSym, doDykstra, eigTol, convTol, posdTol, maxIter)
}

