% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ht_2pop_mean.R
\name{ht_2pop_mean}
\alias{ht_2pop_mean}
\title{Hypothesis testing mean for two populations}
\usage{
ht_2pop_mean(
  x,
  y,
  delta = 0,
  sd_pop_1 = NULL,
  sd_pop_2 = NULL,
  var_equal = FALSE,
  alternative = "two.sided",
  conf_level = NULL,
  sig_level = 0.05,
  na_rm = TRUE
)
}
\arguments{
\item{x}{a (non-empty) numeric vector.}

\item{y}{a (non-empty) numeric vector.}

\item{delta}{a scalar value indicating the difference in means (\eqn{\Delta_0}). Default value is 0.}

\item{sd_pop_1}{a number specifying the known standard deviation of the first population. Default value is \code{NULL}.}

\item{sd_pop_2}{a number specifying the known standard deviation of the second population. Default value is \code{NULL}.}

\item{var_equal}{a logical variable indicating whether to treat the two variances as being equal. If \code{TRUE} then the pooled variance is used to estimate the variance, otherwise the Welch (or Satterthwaite) approximation to the degrees of freedom is used. Default value is \code{FALSE}.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of ‘"two.sided"’ (default), ‘"greater"’ or ‘"less"’.}

\item{conf_level}{a number indicating the confidence level to compute the confidence interval. If \code{conf_level = NULL}, then confidence interval is not included in the output. Default value is \code{NULL}.}

\item{sig_level}{a number indicating the significance level to use in the General Procedure for Hypothesis Testing.}

\item{na_rm}{a logical value indicating whether \code{NA} values should be removed before the computation proceeds.}
}
\value{
a \code{tibble} with the following columns:
\describe{
\item{statistic}{the value of the test statistic.}
\item{p_value}{the p-value for the test.}
\item{critical_value}{critical value in the General Procedure for Hypothesis Testing.}
\item{critical_region}{critical region in the General Procedure for Hypothesis Testing.}
\item{delta}{a scalar value indicating the value of \eqn{\Delta_0}.}
\item{alternative}{character string giving the direction of the alternative hypothesis.}
\item{lower_ci}{lower bound of the confidence interval. It is presented only if \code{!is.null(conf_level)}.}
\item{upper_ci}{upper bound of the confidence interval. It is presented only if \code{!is.null(conf_level)}.}
}
}
\description{
Performs a hypothesis testing for the difference in means of two populations.
}
\details{
We have wrapped the \code{t.test} and the \code{BSDA::z.test} in a function as explained in the book of Montgomery and Runger (2010) <ISBN: 978-1-119-74635-5>.
}
\examples{
# t-test: var_equal == FALSE
x <- rnorm(1000, mean = 10, sd = 2)
y <- rnorm(500, mean = 5, sd = 1)
# H0: mu_1 - mu_2 == -1 versus H1: mu_1 - mu_2 != -1
ht_2pop_mean(x, y, delta = -1)
# t-test: var_equal == TRUE
x <- rnorm(1000, mean = 10, sd = 2)
y <- rnorm(500, mean = 5, sd = 2)
# H0: mu_1 - mu_2 == -1 versus H1: mu_1 - mu_2 != -1
ht_2pop_mean(x, y, delta = -1, var_equal = TRUE)

# z-test
x <- rnorm(1000, mean = 10, sd = 3)
x <- rnorm(500, mean = 5, sd = 1)
# H0: mu_1 - mu_2 >= 0 versus H1: mu_1 - mu_2 < 0
ht_2pop_mean(x, y, delta = 0, sd_pop_1 = 3, sd_pop_2 = 1)
}
