% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ht_1pop_mean.R
\name{ht_1pop_mean}
\alias{ht_1pop_mean}
\title{Hypothesis testing for the mean (normal distribution)}
\usage{
ht_1pop_mean(
  x,
  mu = 0,
  sd_pop = NULL,
  alternative = "two.sided",
  conf_level = NULL,
  sig_level = 0.05,
  na.rm = TRUE
)
}
\arguments{
\item{x}{a (non-empty) numeric vector.}

\item{mu}{a number indicating the true value of the mean. Default value is 0.}

\item{sd_pop}{a number specifying the known standard deviation of the population. If \code{sd_pop == NULL}, we use the t-ttest. If \code{!is.null(sd_pop)}, we use the z-test. Default value is \code{NULL}.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of ‘"two.sided"’ (default), ‘"greater"’ or ‘"less"’. You can specify just the initial letter.}

\item{conf_level}{a number indicating the confidence level to compute the confidence interval. If \code{conf_level = NULL}, then the confidence interval is not included in the output. Default value is \code{NULL}.}

\item{sig_level}{a number indicating the significance level to use in the General Procedure for Hypothesis Testing.}

\item{na.rm}{a logical value indicating whether \code{NA} values should be removed before the computation proceeds.}
}
\value{
a \code{tibble} with the following columns:
\describe{
\item{statistic}{the value of the test statistic.}
\item{p_value}{the p-value of the test.}
\item{critical_value}{critical value in the General Procedure for Hypothesis Testing.}
\item{critical_region}{critical region in the General Procedure for Hypothesis Testing.}
\item{mu}{a number indicating the true value of the mean.}
\item{alternative}{character string giving the direction of the alternative hypothesis.}
\item{lower_ci}{lower bound of the confidence interval. It is presented only if \code{!is.null(con_level)}.}
\item{upper_ci}{upper bound of the confidence interval. It is presented only if \code{!is.null(con_level)}.}
}
}
\description{
Hypothesis testing for the mean (normal distribution)
}
\details{
We have wrapped the \code{t.test} and the \code{BSDA::z.test} in a function as explained in the book of Montgomery and Runger (2010) <ISBN: 978-1-119-74635-5>.
}
\examples{
sample <- rnorm(1000, mean = 10, sd = 2) #t-test
ht_1pop_mean(sample, mu = -1) # H0: mu == -1

sample <- rnorm(1000, mean = 5, sd = 3) # z-test
ht_1pop_mean(sample, mu = 0, sd_pop = 3, alternative = 'less') # H0: mu >= 0
}
