% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_1pop_general.R
\name{ci_1pop_general}
\alias{ci_1pop_general}
\title{Confidence interval for a population mean (general case)}
\usage{
ci_1pop_general(x, conf_level = 0.95, type = "two.sided", na.rm = F)
}
\arguments{
\item{x}{a (non-empty) numeric vector.}

\item{conf_level}{confidence level of the returned confidence interval. Must be a single number between 0 and 1.}

\item{type}{a character string specifying the type of confidence interval. Must be one of "two.sided" (default), "right" or "left".}

\item{na.rm}{a logical value indicating whether \code{NA} values should be removed before the computation proceeds.}
}
\value{
A 1 x 3 tibble with 'lower_ci', 'upper_ci', and 'conf_level' columns. Values correspond to the lower and upper bounds of the confidence interval, and the confidence level, respectively.
}
\description{
Confidence interval for a population mean (general case)
}
\details{
"lower_ci" and "upper_ci" are computed using the \code{t.test} function.
}
\examples{
x <- rpois(1000, lambda = 10)
ci_1pop_general(x)

}
