% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{nhanes}
\alias{nhanes}
\title{US National Health and Nutrition Examination Study}
\format{
An object of class \code{data.frame} with 9643 rows and 9 columns.
}
\source{
\url{https://wwwn.cdc.gov/nchs/nhanes/ContinuousNhanes/Default.aspx?BeginYear=2003}
}
\usage{
nhanes
}
\description{
The US National Health and Nutrition Examination Study (NHANES) is a
survey data collected by the US National Center for Health Statistics.
The survey data dates back to 1999, where individuals of all ages are
interviewed in their home annually and complete the health examination
component of the survey. The study variables include demographic
variables (e.g. age and annual household income), physical measurements
(e.g. BMI – body mass index), health variables (e.g. diabetes status),
and lifestyle variables (e.g. smoking status). This data frame contains
the following columns:
\itemize{
  \item{id: Individual identifier}
  \item{age: Age}
  \item{gender: Sex 1=male, 0=female}
  \item{educ: Education is dichotomized into high school
  and above versus less than high school}
  \item{race: categorical variable with five levels}
  \item{income: Household income ($1000 per year) was reported
  as a range of values in dollar (e.g. 0–4999, 5000–9999, etc.)
  and had 10 interval categories. }
  \item{Income: Household income ($1000 per year) was reported
  as a range of values in dollar (e.g. 0–4999, 5000–9999, etc.)
  and had 10 interval categories. }
  \item{bmi: body mass index}
  \item{sbp: systolic blood pressure}
}
}
\examples{
data("nhanes")
attach(nhanes)
hist(Income, prob= TRUE, breaks = seq(1, 99, 0.5), xlim = c(1,10),
ylim = c(0,0.35), main = "Histogram of Income", xlab = "Category")
data2 <- subset(nhanes, !is.na(sbp))
data3 <- subset(data2, !is.na(bmi))
attach(data3)
data <- data3
data$YS <- ifelse(is.na(data$Income),0,1)
data$educ <- ifelse(data$educ<=2,0,1)
attach(data)
selectionEq <- YS~age+gender+educ+race
outcomeEq   <- sbp~age+gender+educ+bmi

}
\references{
{
  \insertRef{ogundimu2019robust}{ssmodels}

  \insertRef{little2011subsample}{ssmodels}

  \insertRef{ssmrob}{ssmodels}

  \insertRef{sampleSelection}{ssmodels}
}
}
\keyword{datasets}
