% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HeckmanSK.R
\name{HeckmanSK}
\alias{HeckmanSK}
\title{Skew-Normal Sample Selection Model Fit Function}
\usage{
HeckmanSK(
  selection,
  outcome,
  data = sys.frame(sys.parent()),
  lambda,
  start = NULL
)
}
\arguments{
\item{selection}{A formula specifying the selection equation.}

\item{outcome}{A formula specifying the outcome equation.}

\item{data}{A data frame containing the variables.}

\item{lambda}{Initial start value for the skewness parameter (\code{lambda}).}

\item{start}{Optional numeric vector of initial parameter values.}
}
\value{
A list containing:
\itemize{
  \item \code{coefficients}: Named vector of estimated model parameters.
  \item \code{value}: The (negative) log-likelihood at convergence.
  \item \code{loglik}: The maximum log-likelihood.
  \item \code{counts}: Number of gradient evaluations.
  \item \code{hessian}: Hessian matrix at the optimum.
  \item \code{fisher_infoSK}: Approximate Fisher information matrix.
  \item \code{prop_sigmaSK}: Standard errors for the estimates.
  \item \code{level}: Levels of the selection variable.
  \item \code{nObs}: Number of observations.
  \item \code{nParam}: Number of model parameters.
  \item \code{N0}: Number of censored (unobserved) observations.
  \item \code{N1}: Number of observed (uncensored) observations.
  \item \code{NXS}: Number of covariates in the selection equation.
  \item \code{NXO}: Number of covariates in the outcome equation.
  \item \code{df}: Degrees of freedom (observations minus parameters).
  \item \code{aic}: Akaike Information Criterion.
  \item \code{bic}: Bayesian Information Criterion.
  \item \code{initial.value}: Initial parameter values used.
}
}
\description{
Fits a sample selection model based on the Skew-Normal distribution
using Maximum Likelihood Estimation (MLE). This model allows for
asymmetry in the distribution of the outcome variable's error term,
addressing potential skewness.
}
\details{
The function implements MLE for a sample selection model where
the outcome equation's errors follow a Skew-Normal distribution,
as proposed in \insertCite{ogundimu2016sample;textual}{ssmodels}.
The optimization is performed via the BFGS algorithm.

The results include estimates for:
\itemize{
  \item Selection equation coefficients.
  \item Outcome equation coefficients.
  \item Standard deviation of the error term (\code{sigma}).
  \item Correlation between the selection and outcome errors (\code{rho}).
  \item Skewness parameter (\code{lambda}).
  \item Robust standard errors from the Fisher information matrix.
}
}
\examples{
data("Mroz87")
attach(Mroz87)
selectEq <- lfp ~ huswage + kids5 + mtr + fatheduc + educ + city
outcomeEq <- log(wage) ~ educ + city
HeckmanSK(selectEq, outcomeEq, data = Mroz87, lambda = -1.5)

}
\references{
\insertRef{ogundimu2016sample}{ssmodels}
}
