% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{reorient}
\alias{reorient}
\alias{reorient.qts}
\alias{reorient.qts_sample}
\title{QTS Reorientation}
\usage{
reorient(x, disable_normalization = FALSE)

\method{reorient}{qts}(x, disable_normalization = FALSE)

\method{reorient}{qts_sample}(x, disable_normalization = FALSE)
}
\arguments{
\item{x}{An object of class \link{qts} or \link{qts_sample}.}

\item{disable_normalization}{A boolean specifying whether quaternion
normalization should be disabled. Defaults to \code{FALSE}.}
}
\value{
An object of the same class as the input argument \code{x} in which
quaternions measure attitude with respect to the orientation of the sensor
at the first time point.
}
\description{
This function reorients the quaternions in a QTS for representing attitude
with respect to the orientation of the sensor at the first time point.
}
\examples{
reorient(vespa64$igp[[1]])
reorient(vespa64$igp)
}
