% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popover_tip.R
\name{bsTooltip}
\alias{bsTooltip}
\alias{bsTip}
\title{Enhanced Bootstrap3 tooltip}
\usage{
bsTooltip(
  tag,
  title = "",
  placement = "top",
  bgcolor = "black",
  textcolor = "white",
  fontsize = "12px",
  fontweight = "400",
  opacity = 1,
  html = FALSE,
  trigger = "hover",
  click_inside = FALSE
)

bsTip(
  tag,
  title = "",
  placement = "top",
  status = "primary",
  fontsize = "12px",
  fontweight = "400",
  opacity = 1,
  html = FALSE,
  trigger = "hover",
  click_inside = FALSE
)
}
\arguments{
\item{tag}{a shiny tag as input}

\item{title}{string, tooltip text}

\item{placement}{string, one of "top", "bottom", "left", "right", where to put the
tooltip}

\item{bgcolor}{string, background color, valid value of CSS color name or hex value or rgb value}

\item{textcolor}{string, text color, valid value of CSS color name or hex value or rgb value}

\item{fontsize}{string, text font size, valid value of CSS font size, like "10px",
"1rem".}

\item{fontweight}{string, valid font weight unit:
https://www.w3schools.com/cssref/pr_font_weight.asp}

\item{opacity}{numeric, between 0 and 1}

\item{html}{bool, allow title contain HTML code? like \code{"<strong>abc</strong>"}
click | hover | focus | manual.}

\item{trigger}{string, how to trigger the tooltip, one or combination of}

\item{click_inside}{bool, default is \code{FALSE}, whether to allow users to
click content inside the message. See details.}

\item{status}{string, used only for wrapper \link{bsTip}, see details}
}
\value{
shiny tag
}
\description{
Add tooltip to any Shiny element you want. You can also customize
color, font size, background color, trigger event for each individual tooltip.
}
\details{
For trigger methods read: https://getbootstrap.com/docs/3.3/javascript/#tooltips-options.
\subsection{Click inside the message}{

Sometimes developers want to add links for users to click.
By default, the message will be gone once mouse leaves the element, but with
this option to be \code{TRUE}, when users move the mouse inside, the message
element will not be gone, so users can click on the links or other content.

Once this option is used, the triggering method is set to \code{"manual"} and
animation will be removed. This is related to the Javascript method used
behind, some compromises have to be made.

When adding the links, you may also want to turn \code{html = TRUE} in combined.
}

\subsection{Convenient wrapper function}{

\link{bsTip} is the convenient function for \link{bsTooltip}, which has the background
and content color set to 5 different bootstrap colors, you can use \code{status}
to set, one of "primary", "info", "success", "warning", "danger"
}
}
\examples{
if(interactive()){
  library(shiny)
  library(magrittr)
  ui <- fluidPage(
    br(), br(), br(), br(), br(), br(), column(2),
    actionButton("", "Tooltip on the left") \%>\%
      bsTooltip("Tooltip on the left", "left"),
    actionButton("", "Tooltip on the top") \%>\%
      bsTooltip("Tooltip on the top", "top"),
    actionButton("", "Tooltip on the right") \%>\%
      bsTooltip("Tooltip on the right", "right"),
    actionButton("", "Tooltip on the bottom") \%>\%
      bsTooltip("Tooltip on the bottom", "bottom"),
    br(), br(), column(2),
    actionButton("", "primary color") \%>\%
      bsTooltip("primary color", bgcolor = "#0275d8"),
    actionButton("", "danger color") \%>\%
      bsTooltip("danger color", bgcolor = "#d9534f"),
    actionButton("", "warning color") \%>\%
      bsTooltip("warning color", bgcolor = "#f0ad4e"),
    br(), br(), column(2),
    actionButton("", "9px") \%>\%
      bsTooltip("9px", fontsize = "9px"),
    actionButton("", "14px") \%>\%
      bsTooltip("14px", fontsize = "14px"),
    actionButton("", "20px") \%>\%
      bsTooltip("20px", fontsize = "20px"),
    br(), br(), column(2),
    actionButton("", "combined") \%>\%
      bsTooltip(
        "custom tooltip", "bottom",
        "#0275d8", "#eee", "15px"
      ),
    actionButton("", "Clickable with links") \%>\%
      bsTooltip(
         "<div>This message has a <a href='https://google.com'>link</a></div>", "bottom",
         html = TRUE, click_inside = TRUE, bgcolor = "orange"
       )
  )
  server <- function(input, output, session) {}
  shinyApp(ui, server)
}
if(interactive()){
  library(shiny)
  library(magrittr)
  ui <- fluidPage(
    br(), br(), br(), br(), br(), br(), column(2),
    actionButton("", "primary") \%>\%
      bsTip("primary", status = "primary"),
    actionButton("", "info") \%>\%
      bsTip("info", status = "info"),
    actionButton("", "success") \%>\%
      bsTip("success", status = "success"),
    actionButton("", "warning") \%>\%
      bsTip("warning", status = "warning"),
    actionButton("", "danger") \%>\%
      bsTip("danger", status = "danger")
  )
  server <- function(input, output, session) {}
  shinyApp(ui, server)
}
}
