% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_ggproto_visualize.r
\name{plot_pca_scree}
\alias{plot_pca_scree}
\title{Plot 2 components of Principal Component Analysis}
\usage{
plot_pca_scree(data, components = c(1, 2), ...)
}
\arguments{
\item{data}{Numeric matrix or data.frame of the observations.}

\item{components}{The 2 numbers of the principal components to use.}

\item{...}{Optionally pass arguments to \code{proto_default}}
}
\description{
Performs PCA on the data and used \code{proto_default} to plot with percent
variation labels. Also appends a screeplot of the component variances.
}
\examples{
dat <- scale_sd(wine[, 2:6])
plot_pca_scree(data = dat)

## Different components, class coloring
clas <- as.factor(wine$Type)
plot_pca_scree(data = dat, components = c(1, 3), position = "center",
               aes_args = list(color = clas, shape = clas))
}
