% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_STlist.R
\name{summarize_STlist}
\alias{summarize_STlist}
\title{summarize_STlist: Generates a data frame with summary statistics}
\usage{
summarize_STlist(x = NULL)
}
\arguments{
\item{x}{an STlist}
}
\value{
a data frame
}
\description{
Produces a data frame with counts per gene and counts per ROI/spot/cell
}
\details{
The function creates a table with counts per gene and counts per region of interest (ROI),
spot, or cell in the samples stored in the STlist
}
\examples{

# Using included melanoma example (Thrane et al.)
# Download example data set from spatialGE_Data
thrane_tmp = tempdir()
unlink(thrane_tmp, recursive=TRUE)
dir.create(thrane_tmp)
lk='https://github.com/FridleyLab/spatialGE_Data/raw/refs/heads/main/melanoma_thrane.zip?download='
download.file(lk, destfile=paste0(thrane_tmp, '/', 'melanoma_thrane.zip'), mode='wb')
zip_tmp = list.files(thrane_tmp, pattern='melanoma_thrane.zip$', full.names=TRUE)
unzip(zipfile=zip_tmp, exdir=thrane_tmp)
# Generate the file paths to be passed to the STlist function
count_files <- list.files(paste0(thrane_tmp, '/melanoma_thrane'),
                          full.names=TRUE, pattern='counts')
coord_files <- list.files(paste0(thrane_tmp, '/melanoma_thrane'),
                         full.names=TRUE, pattern='mapping')
clin_file <- list.files(paste0(thrane_tmp, '/melanoma_thrane'),
                        full.names=TRUE, pattern='clinical')
# Create STlist
library('spatialGE')
melanoma <- STlist(rnacounts=count_files[c(1,2)],
                   spotcoords=coord_files[c(1,2)],
                   samples=clin_file) # Only first two samples
summarize_STlist(melanoma)

}
