% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STenrich.R
\name{STenrich}
\alias{STenrich}
\title{STenrich}
\usage{
STenrich(
  x = NULL,
  samples = NULL,
  gene_sets = NULL,
  score_type = "avg",
  reps = 1000,
  annot = NULL,
  domain = NULL,
  num_sds = 1,
  min_units = 20,
  min_genes = 5,
  pval_adj_method = "BH",
  seed = 12345,
  cores = NULL,
  verbose = TRUE
)
}
\arguments{
\item{x}{an STlist with transformed gene expression}

\item{samples}{a vector with sample names or indexes to run analysis}

\item{gene_sets}{a named list of gene sets to test. The names of the list should
identify the gene sets to be tested}

\item{score_type}{Controls how gene set expression is calculated. The options are
the average expression among genes in a set ('avg'), or a GSEA score ('gsva'). The
default is 'avg'}

\item{reps}{the number of random samples to be extracted. Default is 1000 replicates}

\item{annot}{name of the annotation within \code{x@spatial_meta} containing the spot/cell
categories. Needs to be used in conjunction with \code{domain}}

\item{domain}{the domain to restrict the analysis. Must exist within the spot/cell
categories included in the selected annotation (i.e., \code{annot})}

\item{num_sds}{the number of standard deviations to set the minimum gene set
expression threshold. Default is one (1) standard deviation}

\item{min_units}{Minimum number of spots with high expression of a pathway for
that gene set to be considered in the analysis. Defaults to 20 spots or cells}

\item{min_genes}{the minimum number of genes of a gene set present in the data set
for that gene set to be included. Default is 5 genes}

\item{pval_adj_method}{the method for multiple comparison adjustment of p-values.
Options are the same as that of \code{p.adjust}. Default is 'BH'}

\item{seed}{the seed number for the selection of random samples. Default is 12345}

\item{cores}{the number of cores used during parallelization. If NULL (default),
the number of cores is defined automatically}

\item{verbose}{either logical or an integer (0, 1, or 2) to increase verbosity}
}
\value{
a list of data frames with the results of the test
}
\description{
Test for spatial enrichment of gene expression sets in ST data sets
}
\details{
The function performs a randomization test to assess if the sum of
distances between cells/spots with high expression of a gene set is lower than
the sum of distances among randomly selected cells/spots. The cells/spots are
considered as having high gene set expression if the average expression of genes in a
set is higher than the average expression plus \code{num_sds} times the standard deviation.
Control over the size of regions with high expression is provided by setting the
minimum number of cells/spots (\code{min_units}). This method is a modification of
the method devised by Hunter et al. 2021 (zebrafish melanoma study).
}
