% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connection_spark.R
\name{spark_connect_method}
\alias{spark_connect_method}
\title{Function that negotiates the connection with the Spark back-end}
\usage{
spark_connect_method(
  x,
  method,
  master,
  spark_home,
  config,
  app_name,
  version,
  hadoop_version,
  extensions,
  scala_version,
  ...
)
}
\arguments{
\item{x}{A dummy method object to determine which code to use to connect}

\item{method}{The method used to connect to Spark. Default connection method
is \code{"shell"} to connect using spark-submit, use \code{"livy"} to
perform remote connections using HTTP, or \code{"databricks"} when using a
Databricks clusters.}

\item{master}{Spark cluster url to connect to. Use \code{"local"} to
connect to a local instance of Spark installed via
\code{\link[=spark_install]{spark_install}}.}

\item{spark_home}{The path to a Spark installation. Defaults to the path
provided by the \code{SPARK_HOME} environment variable. If
\code{SPARK_HOME} is defined, it will always be used unless the
\code{version} parameter is specified to force the use of a locally
installed version.}

\item{config}{Custom configuration for the generated Spark connection. See
\code{\link{spark_config}} for details.}

\item{app_name}{The application name to be used while running in the Spark
cluster.}

\item{version}{The version of Spark to use. Required for \code{"local"} Spark
connections, optional otherwise.}

\item{hadoop_version}{Version of Hadoop to use}

\item{extensions}{Extension R packages to enable for this connection. By
default, all packages enabled through the use of
\code{\link[=register_extension]{sparklyr::register_extension}} will be passed here.}

\item{scala_version}{Load the sparklyr jar file that is built with the version of
Scala specified (this currently only makes sense for Spark 2.4, where sparklyr will
by default assume Spark 2.4 on current host is built with Scala 2.11, and therefore
`scala_version = '2.12'` is needed if sparklyr is connecting to Spark 2.4 built with
Scala 2.12)}

\item{...}{Additional params to be passed to each `spark_disconnect()` call
(e.g., `terminate = TRUE`)}
}
\description{
Function that negotiates the connection with the Spark back-end
}
