% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometrical_functions_sf.R
\name{snapPointsToLines2}
\alias{snapPointsToLines2}
\title{Snap points to lines}
\usage{
snapPointsToLines2(points, lines, idField = NA, ...)
}
\arguments{
\item{points}{A feature collection of points}

\item{lines}{A feature collection of linestrings}

\item{idField}{The name of the column to use as index for the lines}

\item{...}{unused}
}
\value{
A feature collection of points with the projected geometries
}
\description{
Snap points to their nearest lines (edited from maptools)
}
\examples{
# reading the data
data(mtl_network)
data(bike_accidents)
mtl_network$LineID <- 1:nrow(mtl_network)
# snapping point to lines
snapped_points <- snapPointsToLines2(bike_accidents,
    mtl_network,
    "LineID"
)
}
\keyword{internal}
