% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_user_weekly_matchups.R
\name{plot_user_weekly_matchups}
\alias{plot_user_weekly_matchups}
\title{Plot User Weekly Matchups}
\usage{
plot_user_weekly_matchups(
  league_id,
  display_name,
  title = paste0("<b>", display_name, ": Weekly Matchups, Filled by Win/Loss</b>"),
  tick_color = "inherit",
  win_fill = "lightgreen",
  lose_fill = "#f68383"
)
}
\arguments{
\item{league_id}{League ID assigned by Sleeper (numeric).}

\item{display_name}{Display name created by user (string).}

\item{title}{Title for plot, which can include HTML formatting (string).}

\item{tick_color}{Font color, name or hex, for weeks (string).}

\item{win_fill}{Fill color, name or hex, for wins (string).}

\item{lose_fill}{Fill color, name or hex, for losses (string).}
}
\value{
Returns a plot containing the display name's weekly matchups.
}
\description{
Given the league ID and display name, plot the total points scored by
week for the display name and colored by whether the result was a win
or a loss. The x-axis labels show the opposing display name for that
specific week.
}
\examples{
\dontrun{plot_user_weekly_matchups(688281863499907072, "datcommish")}

}
\author{
Nick Bultman, \email{njbultman74@gmail.com}, May 2024
}
\keyword{league}
\keyword{matchups}
\keyword{user}
\keyword{weekly}
