% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posteriors.R
\name{postGamma}
\alias{postGamma}
\title{Perform a Metropolis-Hastings Step for Drawing a New Gamma}
\usage{
postGamma(taui, Zi, currentGamma, phi = 1, rhoGamma = 1000)
}
\arguments{
\item{taui}{A vector of length num_Individuals representing precision parameters for individuals.}

\item{Zi}{A matrix of covariates, where each row represents an individual and each column represents a covariate.}

\item{currentGamma}{A vector (or matrix with 1 row) representing the current Gamma value.}

\item{phi}{A scalar, the prior rate for tau_i.}

\item{rhoGamma}{A scalar representing the proposal distribution precision parameter.}
}
\value{
A list containing the new Gamma value and the corresponding thetai values.
}
\description{
Our model assumes that tau_i ~ Gamma(alpha_i, phi) where alpha_i/phi = theta_i and
g(theta_i) = Z_i^T Gamma, where g is the log-link function.
Because of this GLM formulation we cannot simply draw from a posterior here and instead use a
Metropolis-Hastings step with proposal distribution propGamma ~ MVNormal(currentGamma, rhoGamma*I)
}
\details{
This draw step assumes a log-link function for the Gamma GLM that we are fitting.
}
