% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_fecha_inisintomas}
\alias{plot_fecha_inisintomas}
\title{Generar gráfico de distribución de casos por fecha de inicio de
síntomas}
\usage{
plot_fecha_inisintomas(
  data_agrupada,
  col_fecha = "ini_sin",
  uni_marca = "semanaepi",
  tipo = "barras",
  fuente_data = NULL
)
}
\arguments{
\item{data_agrupada}{Un `data.frame` que contiene los datos de la enfermedad
o evento agrupados.}

\item{col_fecha}{Un `character` (cadena de caracteres) que contiene el
nombre de la columna con las fechas de notificación en los datos de la
enfermedad o evento agrupados; su valor por defecto es `"ini_sin"`.}

\item{uni_marca}{Un `character` (cadena de caracteres) que contiene la unidad
de las marcas del gráfico (`"dia"`, `"semanaepi"` y `"mes"`);
su valor por defecto es `"semanaepi"`.}

\item{tipo}{Un `character` (cadena de caracteres) que contiene el tipo de
gráfico (`"barras"` o `"tendencia"`); su valor por defecto es `"barras"`.}

\item{fuente_data}{Un `character` (cadena de caracteres) que contiene la
leyenda o fuente de información de los datos; su valor por defecto
es `NULL`.}
}
\value{
Un `plot` o gráfico de la distribución de casos por fecha de inicio
de síntomas.
}
\description{
Función que genera un gráfico de distribución de casos
por fecha de inicio de síntomas.
}
\examples{
\donttest{
data(dengue2020)
data_limpia <- limpiar_data_sivigila(dengue2020)
data_agrupada <- agrupar_fecha_inisintomas(
  data_event = data_limpia
)
plot_fecha_inisintomas(
  data_agrupada = data_agrupada,
  col_fecha = "ini_sin",
  uni_marca = "semanaepi"
)
}
}
