% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_cols.R
\name{.add_cols}
\alias{.add_cols}
\alias{.add_date_contact}
\alias{.add_hospitalisation}
\alias{.add_outcome}
\alias{.add_names}
\alias{.add_ct}
\alias{.add_reporting_delay}
\title{Add line list event dates and case information as columns to infectious
history \verb{<data.frame>}}
\usage{
.add_date_contact(
  .data,
  first_contact_distribution,
  last_contact_distribution,
  outbreak_start_date
)

.add_hospitalisation(.data, onset_to_hosp, hosp_risk)

.add_outcome(
  .data,
  onset_to_death,
  onset_to_recovery,
  hosp_death_risk,
  non_hosp_death_risk,
  config
)

.add_names(.data, anonymise = FALSE)

.add_ct(.data, distribution)

.add_reporting_delay(.data, reporting_delay)
}
\arguments{
\item{.data}{A \verb{<data.frame>} containing the infectious history from a
branching process simulation (\code{\link[=.sim_network_bp]{.sim_network_bp()}}).}

\item{first_contact_distribution, last_contact_distribution}{A \code{function} to
generate the time for the first or last contact between the infector
and infectee (exposure window). See \code{\link[=create_config]{create_config()}}.}

\item{outbreak_start_date}{A \code{date} for the start of the outbreak.}

\item{onset_to_hosp}{A \code{function} or an \verb{<epiparameter>} object for the
onset-to-hospitalisation delay distribution. \code{onset_to_hosp} can also be
set to \code{NULL} to not simulate hospitalisation (admission) dates.

The function can be defined or anonymous. The function must return a vector
of \code{numeric}s for the length of the onset-to-hospitalisation delay. The
function must have a single argument.

An \verb{<epiparameter>} can be provided. This will be converted into a random
number generator internally.

The default is an anonymous function with a lognormal distribution random
number generator (\code{\link[=rlnorm]{rlnorm()}}) with \code{meanlog = 1.5} and \code{sdlog = 0.5}.

If \code{onset_to_hosp} is set to \code{NULL} then \code{hosp_risk} and \code{hosp_death_risk}
will be automatically set to \code{NULL} if not manually specified.}

\item{hosp_risk}{Either a single \code{numeric} for the hospitalisation risk of
everyone in the population, or a \verb{<data.frame>} with age specific
hospitalisation risks. Default is 20\% hospitalisation (\code{0.2}) for the entire
population. If the \code{onset_to_hosp} argument is set to \code{NULL} this argument
will automatically be set to \code{NULL} if not specified or can be manually
set to \code{NULL}. See details and examples for more information.}

\item{onset_to_death}{A \code{function} or an \verb{<epiparameter>} object for the
onset-to-death delay distribution. \code{onset_to_death} can also be set to
\code{NULL} to not simulate dates for individuals that died.

The function can be defined or anonymous. The function must return a vector
of \code{numeric}s for the length of the onset-to-death delay. The function must
have a single argument.

An \verb{<epiparameter>} can be provided. This will be converted into a random
number generator internally.

The default is an anonymous function with a lognormal distribution random
number generator (\code{\link[=rlnorm]{rlnorm()}}) with \code{meanlog = 2.5} and \code{sdlog = 0.5}.

If \code{onset_to_death} is set to \code{NULL} then \code{non_hosp_death_risk} and
\code{hosp_death_risk} will be automatically set to \code{NULL} if not manually
specified.

For hospitalised cases, the function ensures the onset-to-death time is
greater than the onset-to-hospitalisation time. After many (1000) attempts,
if an onset-to-death time (from \code{onset_to_death}) cannot be sampled that is
greater than a onset-to-hospitalisation time (from \code{onset_to_hosp}) then
the function will error. Due to this conditional sampling, the
onset-to-death times in the line list may not resemble the distributional
form input into the function.}

\item{onset_to_recovery}{A \code{function} or an \verb{<epiparameter>} object for the
onset-to-recovery delay distribution. \code{onset_to_recovery} can also be \code{NULL}
to not simulate dates for individuals that recovered.

The function can be defined or anonymous. The function must return a vector
of \code{numeric}s for the length of the onset-to-recovery delay. The function
must have a single argument.

An \verb{<epiparameter>} can be provided. This will be converted into a random
number generator internally.

The default is \code{NULL} so by default cases that recover get an \code{NA} in the
\verb{$date_outcome} line list column.

For hospitalised cases, the function ensures the onset-to-recovery time is
greater than the onset-to-hospitalisation time. After many (1000) attempts,
if an onset-to-recovery time (from \code{onset_to_recovery}) cannot be sampled
that is greater than a onset-to-hospitalisation time (from \code{onset_to_hosp})
then the function will error. Due to this conditional sampling, the
onset-to-recovery times in the line list may not resemble the distributional
form input into the function.}

\item{hosp_death_risk}{Either a single \code{numeric} for the death risk for
hospitalised individuals across the population, or a \verb{<data.frame>} with age
specific hospitalised death risks Default is 50\% death risk in hospitals
(\code{0.5}) for the entire population. If the \code{onset_to_death} argument is set
to \code{NULL} this argument will automatically be set to \code{NULL} if not specified
or can be manually set to \code{NULL}. See details and examples for more
information. The \code{hosp_death_risk} can vary through time if specified in
the \code{time_varying_death_risk} element of \code{config}, see
\code{vignette("time-varying-cfr", package = "simulist")} for more information.}

\item{non_hosp_death_risk}{Either a single \code{numeric} for the death risk for
outside of hospitals across the population, or a \verb{<data.frame>} with age
specific death risks outside of hospitals. Default is 5\% death risk outside
of hospitals  (\code{0.05}) for the entire population. If the \code{onset_to_death}
argument is set to \code{NULL} this argument will automatically be set to \code{NULL}
if not specified or can be manually set to \code{NULL}. See details and examples
for more information. The \code{non_hosp_death_risk} can vary through time if
specified in the \code{time_varying_death_risk} element of \code{config}, see
\code{vignette("time-varying-cfr", package = "simulist")} for more information.}

\item{config}{A list of settings to adjust the randomly sampled delays and
Ct values. See \code{\link[=create_config]{create_config()}} for more information.}

\item{anonymise}{A \code{logical} boolean for whether case names should be
anonymised. Default is \code{FALSE}.}

\item{reporting_delay}{A \code{function} for the reporting delay distribution or
\code{NULL}. The (random) number generating function creates delays between the
time of symptom onset (\verb{$date_onset}) and the case being reported
(\verb{$date_reporting}).

The function can be defined or anonymous. The function must return a vector
of \code{numeric}s for the length of the reporting delay. The function must have
a single argument.

The default is \code{NULL} so by default there is no reporting delay, and the
\verb{$date_reporting} line list column is identical to the \verb{$date_onset} column.}
}
\value{
A \verb{<data.frame>} with one more column than input into \code{.data}.
Unless the column heading is already present in which the data is
overwritten.
}
\description{
These \verb{.add_*()} functions add columns to the \verb{<data.frame>}
output by \code{\link[=.sim_network_bp]{.sim_network_bp()}}. The \verb{<data.frame>} supplied to \code{.data} will
have a different number of columns depending on which function is being
called (i.e. the \verb{<data.frame>} supplied to \code{\link[=.add_hospitalisation]{.add_hospitalisation()}} will
have more columns than the \verb{<data.frame>} supplied to \code{\link[=.add_date_contact]{.add_date_contact()}}
as former function is called later in the simulation).

The event date could be first contact, last contact or other.
}
\keyword{internal}
