% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{genMixFormula}
\alias{genMixFormula}
\title{Generate Mixture Formula}
\usage{
genMixFormula(vars, probs = NULL, varLength = NULL)
}
\arguments{
\item{vars}{Character vector/list of variable names.}

\item{probs}{Numeric vector/list of probabilities. Has to be same length as
vars or NULL. Probabilities will be normalized if the sum to > 1.}

\item{varLength}{If \code{vars} is of length one and varLength is set to any
integer > 0, \code{vars} will be interpreted as array of length \code{varLength} and
all elements will used in sequence.}
}
\value{
The mixture formula as a string.
}
\description{
Generates a mixture formula from a vector of variable names and
an optional vector of probabilities.
}
\examples{
genMixFormula(c("a", "..b[..i]", "c"))
genMixFormula(c("a", "..b", "c"), c(.2, .5, .3))

# Shorthand to use external vectors/lists
genMixFormula("..arr", varLength = 5)
}
\concept{utility}
