% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_shrinkDSM.R
\name{predict.shrinkDSM}
\alias{predict.shrinkDSM}
\title{Draw from posterior predictive density of a fitted time-varying parameter survival model}
\usage{
\method{predict}{shrinkDSM}(object, newdata, cens = TRUE, ...)
}
\arguments{
\item{object}{an object of class \code{shrinkDSM}, containing the fitted model.}

\item{newdata}{a data frame containing the covariates used for the prediction.
The names of the covariates
have to match the names used during model estimation in the call to \code{shrinkDSM}.}

\item{cens}{logical value indicating whether the predictions should be censored at the
largest survival time in the data used for estimation.
The default value is \code{TRUE}.}

\item{...}{included for S3 method consistency and currently ignored.}
}
\value{
The value returned is a list object of class \code{shrinkTVP_pred} containing the
samples from the
posterior predictive density.
}
\description{
Draws from the posterior predictive distribution of survival times based on a fitted
time-varying parameter survival model resulting from a call to
\code{shrinkDSM}.
}
\examples{
\donttest{
set.seed(123)
data("gastric")

# Create intervals for piecewise exponential model
intervals <- divisionpoints(gastric$time, gastric$status, 2)

# Estimate model
mod <- shrinkDSM(time ~ radiation, gastric,
                 delta = gastric$status, S = intervals)

# Draw from posterior predictive distribution
newdata <- data.frame(radiation = c(0, 1))
pred <- predict(mod, newdata = newdata)
}
}
\author{
Peter Knaus \email{peter.knaus@wu.ac.at}

Daniel Winkler \email{dwinkler@wu.ac.at}
}
\concept{prediction functions}
