% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Comment.R
\name{Comment}
\alias{Comment}
\alias{getComments}
\alias{getCommentsCount}
\alias{getComment}
\alias{createComment}
\alias{modifyComment}
\alias{markCommentAsSpam}
\alias{markCommentAsNotSpam}
\alias{approveComment}
\alias{removeComment}
\alias{restoreComment}
\title{Comment Functions}
\usage{
getComments(blogId, articleId, ...)

getCommentsCount(blogId, articleId, ...)

getComment(commentId, ...)

createComment(comment, ...)

modifyComment(comment, ...)

markCommentAsSpam(commentId, ...)

markCommentAsNotSpam(commentId, ...)

approveComment(commentId, ...)

removeComment(commentId, ...)

restoreComment(commentId, ...)
}
\arguments{
\item{blogId}{a \code{\link{Blog}} id (leave blank to fetch all comments for the shop)}

\item{articleId}{an Article id (leave blank to fetch all comments for this blog)}

\item{...}{additional request parameters}

\item{commentId}{a Comment id number}

\item{comment}{a list containing Comment fields}
}
\value{
a list containing a Comment fields or a list of Comments
}
\description{
Comment Functions
}
\references{
Shopify API Comment documentation: \url{https://help.shopify.com/api/reference/online_store/comment}
}
