% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validated_input.R
\name{addHelpText}
\alias{addHelpText}
\title{Adds a help icon to an input.}
\usage{
addHelpText(tag, helpText, updated = FALSE)
}
\arguments{
\item{tag}{A tag to be modified.}

\item{helpText}{Help text to be added.}

\item{updated}{An internal parameter which is used in
recurrent calls to the function.}
}
\value{
A modified Shiny tag with a shinyreforms help icon.
}
\description{
Internal function which adds a shinyreforms pop-up
with help text to a shiny inputTag. The help text
is a div which gets appended to the label for the
given input.
}
\examples{
addHelpText(
  shiny::textInput("text_input", label = "Label"),
  helpText = "Tooltip"
)
}
