% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup.R
\name{setupStorage}
\alias{setupStorage}
\title{Set up inputs for storage}
\usage{
setupStorage(
  appId,
  inputs = TRUE,
  outputs = FALSE,
  session = getDefaultReactiveDomain(),
  dyn.inputs = list()
)
}
\arguments{
\item{appId}{your desired application id}

\item{inputs}{choose whether to track all inputs or specific input variables}

\item{outputs}{choose whether to track all outputs or specific output variables}

\item{session}{the session object passed to function. Default is getDefaultReactiveDomain()}

\item{dyn.inputs}{dynamic inputs; inputs that get added to the app from the server function}
}
\value{
Embed within a page storage that allows input changes to be saved without slowing down the shiny application
}
\description{
Set up the application and inputs to track and retrieve stores
}
\details{
As of version 1.2, the user may be able to store dynamically generated inputs \cr
}
\note{
the inputs argument may be a \code{TRUE} or \code{FALSE} or a list of input ids. More examples are located at https://github.com/oobianom/aagarw30_shinyapps_to-shinyStorePlus
}
\examples{
\donttest{
library(shiny)
library(shinyStorePlus)

# example 1 that tracks all inputs
if (interactive()) {
  ui <- shiny::fluidPage(
    titlePanel("EX1
             shinyStorePlus All Inputs"),
    initStore(),
    sidebarLayout(
      sidebarPanel(
        sliderInput("nextgenshinyapps1",
          "Number of bins:",
          min = 1,
          max = 200,
          value = 150
        ),
        textInput(
          "caption",
          "simple caption:",
          "try editing - r2resize pkg"
        ),
        numericInput("obs",
          "sample observations:",
          10,
          min = 1, max = 100
        )
      ),
      mainPanel(
        plotOutput("distPlot")
      )
    )
  )
  server <- function(input, output, session) {
    output$distPlot <- renderPlot({
      x <- faithful[, 2]
      bins <- seq(min(x),
        max(x),
        length.out =
          input$nextgenshinyapps1 + 1
      )
      hist(x,
        breaks = bins,
        col = "blue",
        border = "gray"
      )
    })

    # insert at the bottom
    appid <- "application01"
    setupStorage(
      appId = appid,
      inputs = TRUE
    )
  }
  shiny::shinyApp(ui = ui, server = server)
}


# example 2 that tracks only 2 inputs
if (interactive()) {
  ui <- shiny::fluidPage(
    # init stores
    initStore(),
    titlePanel("Ex2:
             shinyStorePlus Some Inputs"),
    sidebarLayout(
      sidebarPanel(
        sliderInput("nextgenshinyapps1",
          "Number of bins:",
          min = 1,
          max = 200,
          value = 150
        ),
        textInput(
          "caption",
          "simple caption:",
          "summary, try editing"
        ),
        numericInput("obs",
          "sample observations:",
          10,
          min = 1, max = 100
        )
      ),
      mainPanel(
        plotOutput("distPlot")
      )
    )
  )
  server <- function(input, output, session) {
    output$distPlot <- renderPlot({
      x <- faithful[, 2]
      bins <- seq(min(x),
        max(x),
        length.out =
          input$nextgenshinyapps1 + 1
      )
      hist(x,
        breaks = bins,
        col = "blue",
        border = "gray"
      )
    })

    # insert at the bottom  !!!IMPORTANT
    appid <- "application023"
    setupStorage(
      appId = appid,
      inputs = list(
        "nextgenshinyapps1",
        "caption"
      )
    )
  }
  shiny::shinyApp(ui = ui, server = server)
}

# example 3 with dynamically generated inputs
if(interactive()){
  ui <- shiny::fluidPage(
    titlePanel("Select option,
               then referesh page."),
    initStore(),
    selectInput("sel_color",
                "Color (hardcoded input):",
                choices = c("", "green", "blue",
                            "red", "yellow",
                            "cyan"), selected = ""),
    uiOutput("ui_moreinputs")
  )

  server <- function(input, output, session) {
    observe({
      output$ui_moreinputs <- renderUI(
        selectInput("sel_month",
                    "Month (dynamically generated):",
                    choices = c("", month.name),
                    selected = "")
      )
    })

    setupStorage(appId = "dynamic02",
                 inputs = list("sel_color"),
                 dyn.inputs = list("sel_month"),
                 session = session)
  }

  shinyApp(ui = ui, server = server)
}


}

}
