% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Chips.R
\name{f7Chip}
\alias{f7Chip}
\title{Framework7 chips}
\usage{
f7Chip(
  label = NULL,
  image = NULL,
  icon = NULL,
  outline = FALSE,
  status = NULL,
  iconStatus = NULL,
  closable = FALSE
)
}
\arguments{
\item{label}{Chip label.}

\item{image}{Chip image, if any.}

\item{icon}{Icon, if any. IOS and Material icons available.}

\item{outline}{Whether to outline chip. FALSE by default.}

\item{status}{Chip color: see here for valid colors \url{https://framework7.io/docs/chips.html}.}

\item{iconStatus}{Chip icon color: see here for valid colors \url{https://framework7.io/docs/chips.html}.}

\item{closable}{Whether to close the chip. FALSE by default.}
}
\description{
\link{f7Chip} is an improved badge container.
}
\examples{
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shinyApp(
  ui = f7Page(
    title = "Chips",
    f7SingleLayout(
      navbar = f7Navbar(title = "f7Chip"),
      f7Block(
        strong = TRUE,
        f7Chip(label = "simple Chip"),
        f7Chip(label = "outline Chip", outline = TRUE),
        f7Chip(label = "icon Chip", icon = f7Icon("add_round"), iconStatus = "pink"),
        f7Chip(label = "image Chip", image = "https://lorempixel.com/64/64/people/9/"),
        f7Chip(label = "closable Chip", closable = TRUE),
        f7Chip(label = "colored Chip", status = "green"),
        f7Chip(label = "colored outline Chip", status = "green", outline = TRUE)
      )
    )
  ),
  server = function(input, output) {}
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
