% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-inputs.R
\name{f7DatePicker}
\alias{f7DatePicker}
\alias{updateF7DatePicker}
\title{Framework7 date picker}
\usage{
f7DatePicker(
  inputId,
  label,
  value = NULL,
  multiple = FALSE,
  direction = c("horizontal", "vertical"),
  minDate = NULL,
  maxDate = NULL,
  dateFormat = "yyyy-mm-dd",
  openIn = c("auto", "popover", "sheet", "customModal"),
  scrollToInput = FALSE,
  closeByOutsideClick = TRUE,
  toolbar = TRUE,
  toolbarCloseText = "Done",
  header = FALSE,
  headerPlaceholder = "Select date"
)

updateF7DatePicker(
  inputId,
  value = NULL,
  ...,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{inputId}{The id of the input object.}

\item{label}{Input label.}

\item{value}{The new value for the input.}

\item{multiple}{If \code{TRUE} allow to select multiple dates.}

\item{direction}{Months layout direction, could be 'horizontal' or 'vertical'.}

\item{minDate}{Minimum allowed date.}

\item{maxDate}{Maximum allowed date.}

\item{dateFormat}{Date format: "yyyy-mm-dd", for instance.}

\item{openIn}{Can be auto, popover (to open calendar in popover), sheet
(to open in sheet modal) or customModal (to open in custom Calendar modal overlay).
In case of auto will open in sheet modal on small screens and in popover on large screens.}

\item{scrollToInput}{Scroll viewport (page-content) to input when calendar opened.}

\item{closeByOutsideClick}{If enabled, picker will be closed by clicking outside of picker or related input element.}

\item{toolbar}{Enables calendar toolbar.}

\item{toolbarCloseText}{Text for Done/Close toolbar button.}

\item{header}{Enables calendar header.}

\item{headerPlaceholder}{Default calendar header placeholder text.}

\item{...}{Parameters used to update the date picker,
use same arguments as in \code{\link{f7DatePicker}}.}

\item{session}{The Shiny session object, usually the default value will suffice.}
}
\value{
a \code{Date} vector.
}
\description{
\link{f7DatePicker} creates a Framework7 date picker input.

\link{updateF7DatePicker} changes the value of a date picker input on the client.
}
\examples{
# Date picker
if (interactive()) {
  library(shiny)
  library(shinyMobile)

  shinyApp(
    ui = f7Page(
      title = "My app",
      f7SingleLayout(
        navbar = f7Navbar(title = "f7DatePicker"),
        f7DatePicker(
          inputId = "date",
          label = "Choose a date",
          value = "2019-08-24"
        ),
        "The selected date is",
        verbatimTextOutput("selectDate"),
        f7DatePicker(
          inputId = "multipleDates",
          label = "Choose multiple dates",
          value = Sys.Date() + 0:3,
          multiple = TRUE
        ),
        "The selected date is",
        verbatimTextOutput("selectMultipleDates"),
        f7DatePicker(
          inputId = "default",
          label = "Choose a date",
          value = NULL
        ),
        "The selected date is",
        verbatimTextOutput("selectDefault")
      )
    ),
    server = function(input, output, session) {

      output$selectDate <- renderPrint(input$date)
      output$selectMultipleDates <- renderPrint(input$multipleDates)
      output$selectDefault <- renderPrint(input$default)

    }
  )
}
# Update date picker
if (interactive()) {
  library(shiny)
  library(shinyMobile)

  shinyApp(
    ui = f7Page(
      title = "My app",
      f7SingleLayout(
        navbar = f7Navbar(title = "Update date picker"),
        f7Card(
          f7Button(inputId = "selectToday", label = "Select today"),
          f7Button(inputId = "rmToolbar", label = "Remove toolbar"),
          f7Button(inputId = "addToolbar", label = "Add toolbar"),
          f7DatePicker(
            inputId = "mypicker",
            label = "Choose a date",
            value = Sys.Date() - 7,
            openIn = "auto",
            direction = "horizontal"
          ),
          verbatimTextOutput("pickerval")
        )
      )
    ),
    server = function(input, output, session) {

      output$pickerval <- renderPrint(input$mypicker)

      observeEvent(input$selectToday, {
        updateF7DatePicker(
          inputId = "mypicker",
          value = Sys.Date()
        )
      })

      observeEvent(input$rmToolbar, {
        updateF7DatePicker(
          inputId = "mypicker",
          toolbar = FALSE,
          dateFormat = "yyyy-mm-dd" # preserve date format
        )
      })

      observeEvent(input$addToolbar, {
        updateF7DatePicker(
          inputId = "mypicker",
          toolbar = TRUE,
          dateFormat = "yyyy-mm-dd" # preserve date format
        )
      })

    }
  )
}
}
