% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-inputs.R
\name{f7checkBox}
\alias{f7checkBox}
\alias{f7Checkbox}
\alias{updateF7Checkbox}
\title{Framework7 checkbox}
\usage{
f7checkBox(inputId, label, value = FALSE)

f7Checkbox(inputId, label, value = FALSE)

updateF7Checkbox(
  inputId,
  label = NULL,
  value = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{inputId}{The id of the input object.}

\item{label}{The label to set for the input object.}

\item{value}{The value to set for the input object.}

\item{session}{The Shiny session object.}
}
\description{
Deprecated. \link{f7checkBox} creates a checkbox input.

\link{f7Checkbox} creates a checkbox input.

\link{updateF7Checkbox} changes the value of a checkbox input on the client.
}
\examples{
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shinyApp(
   ui = f7Page(
    title = "My app",
    f7SingleLayout(
     navbar = f7Navbar(title = "f7checkBox"),
     f7Card(
      f7checkBox(
       inputId = "check",
       label = "Checkbox",
       value = FALSE
      ),
      verbatimTextOutput("test")
     )
    )
   ),
   server = function(input, output) {
    output$test <- renderPrint({input$check})
   }
 )
}
if (interactive()) {
 library(shiny)
 library(shinyMobile)

 ui <- f7Page(
   f7SingleLayout(
    navbar = f7Navbar(title = "updateF7CheckBox"),
    f7Slider(
     inputId = "controller",
     label = "Number of observations",
     max = 10,
     min = 0,
     value = 1,
     step = 1,
     scale = TRUE
    ),
    f7checkBox(
     inputId = "check",
     label = "Checkbox"
    )
   )
 )

 server <- function(input, output, session) {
   observe({
     # TRUE if input$controller is odd, FALSE if even.
     x_even <- input$controller \%\% 2 == 1

     if (x_even) {
      showNotification(
       id = "notif",
       paste("The slider is ", input$controller, "and the checkbox is", input$check),
       duration = NULL,
       type = "warning"
      )
     } else {
      removeNotification("notif")
     }

     updateF7Checkbox("check", value = x_even)
   })
 }

shinyApp(ui, server)
}
}
