% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Toast.R
\name{f7Toast}
\alias{f7Toast}
\title{Create a Framework7 toast}
\usage{
f7Toast(
  session,
  text,
  position = c("bottom", "top", "center"),
  closeButton = TRUE,
  closeButtonText = "close",
  closeButtonColor = "red",
  closeTimeout = 3000,
  icon = NULL
)
}
\arguments{
\item{session}{Shiny session.}

\item{text}{Toast content.}

\item{position}{Toast position \code{c("bottom", "top", "center")}.}

\item{closeButton}{Whether to close the toast with a button.
TRUE by default.}

\item{closeButtonText}{Close button text.}

\item{closeButtonColor}{Close button color.}

\item{closeTimeout}{Time before toast closes.}

\item{icon}{Optional. Expect \link{f7Icon}. Warning:
Adding icon will hide the close button.}
}
\description{
Create a Framework7 toast
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)
 shinyApp(
  ui = f7Page(
    title = "My app",
    f7SingleLayout(
      navbar = f7Navbar(title = "f7Toast"),
      f7Button(inputId = "toast", label = "Open Toast")
    )
  ),
  server = function(input, output, session) {
    observeEvent(input$toast, {
      f7Toast(
        session,
        position = "top",
        text = "I am a toast. Eat me!"
      )
    })
  }
 )
}
}
