% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{downloadButton}
\alias{downloadButton}
\alias{downloadLink}
\title{Create a download button or link}
\usage{
downloadButton(
  outputId,
  label = "Download",
  class = NULL,
  ...,
  icon = shiny::icon("download")
)

downloadLink(outputId, label = "Download", class = NULL, ...)
}
\arguments{
\item{outputId}{The name of the output slot that the \code{downloadHandler}
is assigned to.}

\item{label}{The label that should appear on the button.}

\item{class}{Additional CSS classes to apply to the tag, if any.}

\item{...}{Other arguments to pass to the container tag function.}

\item{icon}{An \code{\link[=icon]{icon()}} to appear on the button. Default is \code{icon("download")}.}
}
\description{
Use these functions to create a download button or link; when clicked, it
will initiate a browser download. The filename and contents are specified by
the corresponding \code{\link[=downloadHandler]{downloadHandler()}} defined in the server
function.
}
\examples{
\dontrun{
ui <- fluidPage(
  p("Choose a dataset to download."),
  selectInput("dataset", "Dataset", choices = c("mtcars", "airquality")),
  downloadButton("downloadData", "Download")
)

server <- function(input, output) {
  # The requested dataset
  data <- reactive({
    get(input$dataset)
  })

  output$downloadData <- downloadHandler(
    filename = function() {
      # Use the selected dataset as the suggested file name
      paste0(input$dataset, ".csv")
    },
    content = function(file) {
      # Write the dataset to the `file` that will be downloaded
      write.csv(data(), file)
    }
  )
}

shinyApp(ui, server)
}

}
\seealso{
\code{\link[=downloadHandler]{downloadHandler()}}
}
