% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approach_vaeac_torch_modules.R
\name{vaeac_dataset}
\alias{vaeac_dataset}
\title{Dataset used by the \code{vaeac} model}
\usage{
vaeac_dataset(X, one_hot_max_sizes)
}
\arguments{
\item{X}{A torch_tensor contain the data of shape N x p, where N and p are the number
of observations and features, respectively.}

\item{one_hot_max_sizes}{A torch tensor of dimension \code{n_features} containing the one hot sizes of the \code{n_features}
features. That is, if the \code{i}th feature is a categorical feature with 5 levels, then \code{one_hot_max_sizes[i] = 5}.
While the size for continuous features can either be \code{0} or \code{1}.}
}
\description{
Convert a the data into a \code{\link[torch:dataset]{torch::dataset()}} which the vaeac model creates batches from.
}
\details{
This function creates a \code{\link[torch:dataset]{torch::dataset()}} object that represent a map from keys to data samples.
It is used by the \code{\link[torch:dataloader]{torch::dataloader()}} to load data which should be used to extract the
batches for all epochs in the training phase of the neural network. Note that a dataset object
is an R6 instance, see \url{https://r6.r-lib.org/articles/Introduction.html}, which is classical
object-oriented programming, with self reference. I.e, \code{\link[=vaeac_dataset]{vaeac_dataset()}} is a subclass
of type \code{\link[torch:dataset]{torch::dataset()}}.
}
\author{
Lars Henry Berge Olsen
}
\keyword{internal}
