% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sd_ellipse.R
\name{st_sd_ellipse}
\alias{st_sd_ellipse}
\alias{st_sd_ellipse.sfg}
\alias{st_sd_ellipse.sf}
\alias{st_sd_ellipse.sfc}
\title{Standard deviation ellipse calculator}
\usage{
st_sd_ellipse(.x, centre = NULL, weights = NULL, ...)

\method{st_sd_ellipse}{sfg}(.x, centre = NULL, weights = NULL, ...)

\method{st_sd_ellipse}{sf}(.x, centre = NULL, weights = NULL, ...)

\method{st_sd_ellipse}{sfc}(.x, centre = NULL, weights = NULL, ...)
}
\arguments{
\item{.x}{\code{sf} points 2D or 3D}

\item{centre}{Numeric. Coordinates 2D of central point. Default NULL,
performs a calculation of \code{mean_centre()} from point localities}

\item{weights}{Numeric. Same length of number of points.}

\item{...}{ignored}
}
\value{
simple features as "POLYGON"  with atributes:
centre coordinates, values for mayor and minor axis radius (sigma.x and sigma.y),
rotation (theta and theta_corrected) and geometry properties (eccentricity, area
and perimeter)
}
\description{
Calculate the spatial deviaction ellipse from a points sf dataset.
}
\examples{
  requireNamespace("ggplot2", quietly = TRUE)
  library(sf, quietly = TRUE)
  library(ggplot2)
  bbx <- matrix(c(697047,9553483,
                  696158,9560476,
                  700964,9561425,
                  701745,9555358),
                byrow = TRUE,
                ncol = 2)
  bbx <- st_multipoint(bbx)
  bbx <- st_cast(bbx,"POLYGON")
  bbx <- st_sfc(bbx, crs = 31992)
  set.seed(1234)
  points <- st_sf(geometry = st_sample(bbx, 100))
  SDE <- st_sd_ellipse(points)
  ggplot() +
    geom_sf(data = SDE, fill = NA, color = "darkolivegreen") +
    geom_sf(data = points, color = "steelblue", size = 0.5)
}
\author{
Gabriel Gaona
}
