% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nodes_keep_drop.R
\name{keep_drop_nodes}
\alias{keep_drop_nodes}
\alias{drop_nodes}
\alias{keep_nodes}
\title{Keep or drop nodes}
\usage{
drop_nodes(object, nodes)

keep_nodes(object, nodes)
}
\arguments{
\item{object}{An an \code{\link[semPlot:semPlotModel]{semPlot::semPlotModel}} generated by
\code{\link[semPlot:semPlotModel]{semPlot::semPlotModel()}}.}

\item{nodes}{A character vector of the nodes to be kept or removed.}
}
\value{
An object of the class \code{\link[semPlot:semPlotModel]{semPlot::semPlotModel}}.
}
\description{
Keep or drop nodes from an semPlotModel object.
}
\details{
These functions can be used to edit the nodes in an
\code{\link[semPlot:semPlotModel]{semPlot::semPlotModel}} generated by \code{\link[semPlot:semPlotModel]{semPlot::semPlotModel()}}.
The edited object can then be passed to \code{\link[semPlot:semPaths]{semPlot::semPaths()}} to
generate a path diagram.

Use \code{\link[=keep_nodes]{keep_nodes()}} to specify the nodes to be kept. All other nodes
will be removed.

Use \code{\link[=drop_nodes]{drop_nodes()}} to specify the nodes to be dropped. All other
nodes will be kept.
}
\examples{
mod_pa <-
  'x1 ~~ x2
   x3 ~  x1 + x2
   x4 ~  x1 + x3
  '
fit_pa <- lavaan::sem(mod_pa, pa_example)
m <- matrix(c("x1",   NA,   NA,
             NA, "x3", "x4",
             "x2",   NA,   NA), byrow = TRUE, 3, 3)
pm_pa <- semPlot::semPlotModel(fit_pa)
semPlot::semPaths(pm_pa, whatLabels = "est",
                 style = "ram",
                 nCharNodes = 0, nCharEdges = 0,
                 layout = m)
pm_pa2 <- drop_nodes(pm_pa, c("x3"))
semPlot::semPaths(pm_pa2, whatLabels = "est",
                 style = "ram",
                 nCharNodes = 0, nCharEdges = 0,
                 layout = m)
pm_pa3 <- keep_nodes(pm_pa, c("x1", "x3", "x4"))
semPlot::semPaths(pm_pa3, whatLabels = "est",
                 style = "ram",
                 nCharNodes = 0, nCharEdges = 0,
                 layout = m)
}
