% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spdep_helpers.R
\name{spdep_contiguity_swm}
\alias{spdep_contiguity_swm}
\title{constructs spatial weight matrices based on contiguity}
\usage{
spdep_contiguity_swm(
  sfj,
  queen = TRUE,
  k = NULL,
  order = 1L,
  cumulate = TRUE,
  style = "W",
  zero.policy = TRUE
)
}
\arguments{
\item{sfj}{An sf object.}

\item{queen}{(optional) if \code{TRUE}, using queen contiguity, otherwise rook contiguity.
Default is \code{TRUE}.}

\item{k}{(optional) The number of nearest neighbours. Ignore this parameter when not
using distance based neighbours to construct spatial weight matrices.}

\item{order}{(optional) The order of the adjacency object. Default is \code{1}.}

\item{cumulate}{(optional) Whether to accumulate adjacency objects. Default is \code{TRUE}.}

\item{style}{(optional) \code{style} can take values \code{W}, \code{B}, \code{C}, and \code{S}. More to see
\code{spdep::nb2mat()}. Default is \code{W}.}

\item{zero.policy}{(optional)  if \code{FALSE} stop with error for any empty neighbour sets,
if \code{TRUE} permit the weights list to be formed with zero-length weights vectors. Default
is \code{TRUE}.}
}
\value{
A matrix
}
\description{
Constructs spatial weight matrices based on contiguity via \code{spdep} package.
}
\note{
When \code{k} is set to a positive value, using K-Nearest Neighbor Weights.
}
\examples{
library(sf)
pts = read_sf(system.file('extdata/pts.gpkg',package = 'sdsfun'))

wt1 = spdep_contiguity_swm(pts, k = 6, style = 'B')
wt2 = spdep_contiguity_swm(pts, queen = TRUE, style = 'B')
wt2 = spdep_contiguity_swm(pts, queen = FALSE, order = 2, style = 'B')

}
