% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_data_handling.R
\name{merge_pred_and_obs}
\alias{merge_pred_and_obs}
\title{Merge Forecast Data And Observations}
\usage{
merge_pred_and_obs(
  forecasts,
  observations,
  join = c("left", "full", "right"),
  by = NULL
)
}
\arguments{
\item{forecasts}{data.frame with the forecast data (as can be passed to
\code{\link[=score]{score()}}).}

\item{observations}{data.frame with the observations}

\item{join}{character, one of \code{c("left", "full", "right")}. Determines the
type of the join. Usually, a left join is appropriate, but sometimes you
may want to do a full join to keep dates for which there is a forecast, but
no ground truth data.}

\item{by}{character vector that denotes the columns by which to merge. Any
value that is not a column in observations will be removed.}
}
\value{
a data.frame with forecasts and observations
}
\description{
The function more or less provides a wrapper around \code{merge} that
aims to handle the merging well if additional columns are present
in one or both data sets. If in doubt, you should probably merge the
data sets manually.
}
\examples{
forecasts <- example_quantile_forecasts_only
observations <- example_truth_only
merge_pred_and_obs(forecasts, observations)
}
\keyword{data-handling}
