% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cheese_abundance}
\alias{cheese_abundance}
\alias{cheese_taxonomy}
\title{Abundance of Fungal Communities in Cheese}
\format{
For \code{cheese_abundance}, a \link[tibble:tibble-package]{tibble}
with columns:
\describe{
\item{sample}{Sample ID.}
\item{cheese}{Appellation of the cheese. One of \code{Saint-Nectaire},
\code{Livarot} or \code{Epoisses}.}
\item{rind_type}{One of \code{Natural} or \code{Washed}.}
\item{other columns}{Count of the ASV.}
}

For \code{cheese_taxonomy}, a \link[tibble:tibble-package]{tibble}
with columns:
\describe{
\item{asv}{Amplicon Sequence Variant (ASV) ID.}
\item{lineage}{Character corresponding to a standard concatenation of
taxonomic clades.}
\item{other columns}{Clade to which the ASV belongs.}
}
}
\source{
This dataset came from \doi{10.24072/pcjournal.321}.
}
\usage{
data("cheese_abundance", package = "scimo")

data("cheese_taxonomy", package = "scimo")
}
\description{
Fungal community abundance of 74 ASVs sampled from the surface of three
different French cheeses.
}
\examples{
data("cheese_abundance", package = "scimo")
cheese_abundance
data("cheese_taxonomy", package = "scimo")
cheese_taxonomy
}
\keyword{datasets}
