% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color-spaces.R
\name{xyz_to_hsl}
\alias{xyz_to_hsl}
\title{Convert XYZ to HSL}
\usage{
xyz_to_hsl(xyz, transformation = "sRGB", linear_func = NULL)
}
\arguments{
\item{xyz}{A dataframe or matrix with X, Y and Z colour channels located in the columns 1 to 3, respectively.}

\item{transformation}{An option in \code{c("sRGB", "Adobe")} for a built-in transformation or, alternatively, a custom 3x3 transformation matrix.}

\item{linear_func}{A function to convert RGB colour space into linear RGB space. Used only if a custom transformation matrix is provided. Transformation skips if no function is provided under a user-defined transformation matrix. See: https://en.wikipedia.org/wiki/SRGB.}
}
\value{
A \code{tibble} of H, S and L colour channels.
}
\description{
Convert XYZ to HSL
}
