% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color-spaces.R
\name{hex_to_xyz}
\alias{hex_to_xyz}
\title{Convert hex RGB values to XYZ space.}
\usage{
hex_to_xyz(hex, transformation = "sRGB", linear_func = NULL)
}
\arguments{
\item{hex}{A character vector containing hex representations of RGB colours.}

\item{transformation}{An option in \code{c("sRGB", "Adobe")} for a built-in transformation or, alternatively, a custom 3x3 transformation matrix.}

\item{linear_func}{A function to convert RGB colour space into non-linear RGB space. Used only if a custom transformation matrix is provided. Transformation skips if no function is provided under a user-defined transformation matrix. See: https://en.wikipedia.org/wiki/SRGB.}
}
\value{
A \code{tibble} of X, Y and Z colour space values.
}
\description{
Convert hex RGB values to XYZ space.
}
\examples{
red <- sample(x = 1:255, size = 10, replace = TRUE)
green <- sample(x = 1:255, size = 10, replace = TRUE)
blue <- sample(x = 1:255, size = 10, replace = TRUE)
hex_to_xyz(rgb_to_hex(data.frame(r = red, g = green, b = blue)))
}
