% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatterPlotMatrix.R
\name{setRegressionType}
\alias{setRegressionType}
\title{Tells which type of regression to use for regression plots.}
\usage{
setRegressionType(id, regressionType)
}
\arguments{
\item{id}{Output variable to read from (id which references the requested plot).}

\item{regressionType}{Binary code indicating the type of regression plot (bit 1: linear, bit 2: loess).}
}
\value{
No return value, called from shiny applications for side effects.
}
\description{
Tells which type of regression to use for regression plots.
}
\examples{
 if(interactive()) {
   library(shiny)
   library(scatterPlotMatrix)

   ui <- fluidPage(
     checkboxInput("linearRegressionCB", "Linear Regression", FALSE),
     checkboxInput("loessCB", "Local Polynomial Regression", FALSE),
     p("The chech boxes controls type of regression to use for regression plots"),
     scatterPlotMatrixOutput("spMatrix")
   )

   server <- function(input, output, session) {
     output$spMatrix <- renderScatterPlotMatrix({
       scatterPlotMatrix(iris)
     })
     observe({
       linearFlag <- ifelse(input$linearRegressionCB, 1, 0)
       loessFlag <- ifelse(input$loessCB, 2, 0)
       scatterPlotMatrix::setRegressionType("spMatrix", linearFlag + loessFlag)
     })
   }

   shinyApp(ui, server)
 }

}
