% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotting_QC_Seurat.R
\name{QC_Plot_UMIvsGene}
\alias{QC_Plot_UMIvsGene}
\title{QC Plots Genes vs UMIs}
\usage{
QC_Plot_UMIvsGene(
  seurat_object,
  x_axis_label = "UMIs per Cell/Nucleus",
  y_axis_label = "Genes per Cell/Nucleus",
  low_cutoff_gene = -Inf,
  high_cutoff_gene = Inf,
  low_cutoff_UMI = -Inf,
  high_cutoff_UMI = Inf,
  cutoff_line_width = NULL,
  colors_use = NULL,
  meta_gradient_name = NULL,
  meta_gradient_color = viridis_plasma_dark_high,
  meta_gradient_na_color = "lightgray",
  meta_gradient_low_cutoff = NULL,
  cells = NULL,
  combination = FALSE,
  ident_legend = TRUE,
  pt.size = 1,
  group.by = NULL,
  raster = NULL,
  raster.dpi = c(512, 512),
  ggplot_default_colors = FALSE,
  color_seed = 123,
  shuffle_seed = 1,
  ...
)
}
\arguments{
\item{seurat_object}{Seurat object name.}

\item{x_axis_label}{Label for x axis.}

\item{y_axis_label}{Label for y axis.}

\item{low_cutoff_gene}{Plot line a potential low threshold for filtering genes per cell.}

\item{high_cutoff_gene}{Plot line a potential high threshold for filtering genes per cell.}

\item{low_cutoff_UMI}{Plot line a potential low threshold for filtering UMIs per cell.}

\item{high_cutoff_UMI}{Plot line a potential high threshold for filtering UMIs per cell.}

\item{cutoff_line_width}{numerical value for thickness of cutoff lines, default is NULL.}

\item{colors_use}{vector of colors to use for plotting by identity.}

\item{meta_gradient_name}{Name of continuous meta data variable to color points in plot by.
(MUST be continuous variable i.e. "percent_mito").}

\item{meta_gradient_color}{The gradient color palette to use for plotting of meta variable (default is
viridis "Plasma" palette with dark colors high).}

\item{meta_gradient_na_color}{Color to use for plotting values when a \code{meta_gradient_low_cutoff} is
set (default is "lightgray").}

\item{meta_gradient_low_cutoff}{Value to use as threshold for plotting.  \code{meta_gradient_name} values
below this value will be plotted using \code{meta_gradient_na_color}.}

\item{cells}{Cells to include on the scatter plot (default is all cells).}

\item{combination}{logical (default FALSE).  Whether or not to return a plot layout with both the
plot colored by identity and the meta data gradient plot.}

\item{ident_legend}{logical, whether to plot the legend containing identities (left plot) when
\code{combination = TRUE}.  Default is TRUE.}

\item{pt.size}{Passes size of points to both \code{\link[Seurat]{FeatureScatter}} and \code{geom_point}.}

\item{group.by}{Name of one or more metadata columns to group (color) cells by (for example, orig.ident).
Default is \verb{@active.ident}.}

\item{raster}{Convert points to raster format.  Default is NULL which will rasterize by default if
greater than 100,000 cells.}

\item{raster.dpi}{Pixel resolution for rasterized plots, passed to geom_scattermore().
Default is c(512, 512).}

\item{ggplot_default_colors}{logical.  If \code{colors_use = NULL}, Whether or not to return plot using
default ggplot2 "hue" palette instead of default "polychrome" or "varibow" palettes.}

\item{color_seed}{Random seed for the "varibow" palette shuffle if \code{colors_use = NULL} and number of
groups plotted is greater than 36.  Default = 123.}

\item{shuffle_seed}{Sets the seed if randomly shuffling the order of points (Default is 1).}

\item{...}{Extra parameters passed to \code{\link[Seurat]{FeatureScatter}}.}
}
\value{
A ggplot object
}
\description{
Custom FeatureScatter for initial QC checks including lines for thresholding
}
\examples{
library(Seurat)
QC_Plot_UMIvsGene(seurat_object = pbmc_small, x_axis_label = "UMIs per Cell/Nucleus",
y_axis_label = "Genes per Cell/Nucleus")

}
\concept{object_qc_plotting}
