% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chooseICavg.R
\name{chooseICavg}
\alias{chooseICavg}
\title{Get index of appropriate initial condition average profile}
\usage{
chooseICavg(
  set,
  n,
  classifyPWLs,
  classifyCRs,
  nPWL = round((2 * n/3) + 0.001),
  sm = summary(set)
)
}
\arguments{
\item{set}{a \link{snowprofileSet}}

\item{n}{number of profile indices to be picked (i.e., returned)}

\item{classifyPWLs}{an argument list for a function call to \link[sarp.snowprofile:findPWL]{sarp.snowprofile::findPWL} which returns relevant PWLs for identifying initial conditions}

\item{classifyCRs}{an argument list for a function call to \link[sarp.snowprofile:findPWL]{sarp.snowprofile::findPWL} which returns relevant CR(ust)s for identifying initial conditions}

\item{nPWL}{number of profile indices to be picked from profiles that have many PWLs in many different vertical levels; an analogous \code{nCR} will be the difference \code{n - nPWL}.}

\item{sm}{a (precomputed) summary of the \code{set}}
}
\value{
\code{n} number of indices that correspond to profiles in the \code{set}
}
\description{
To average a set of snow profiles, \link{dbaSP} requires a snow profile as initial condition (IC) to start the algorithm. To prevent persistent weak layers (PWLs) and crusts
from being averaged-out during the call to \code{dbaSP}, it is advised to start the algorithm with a best-guess IC. This best guess IC contains a large number of PWLs and crusts to ensure
that the most prevalent ones actually make their way into the final average profile. This function helps to choose meaningful IC profiles. See Details or (better) the source code
for how this function picks the profiles.
}
\details{
This function first computes how many PWLs and how many crusts are in the profiles that have a close to median total snow height HS.
Each of these profile is then divided into several vertical levels (by \link{numberOfPWLsPerVerticalLevel}).
nPWL and nCR profiles are then randomly picked from the profiles that have PWLs or CR in most vertical levels and additionally have a rather large number of PWLs/CR overall.
The larger \code{n}, the more profiles with decreasing number of PWLs/CR in different levels are also returned. Note that this function is best applied
to large profile sets to obtain semi-random results. For small sets, the indices returned can actually be deterministic since the pool of relevant profiles is too small.
}
\examples{
plot(SPgroup, SortMethod = "unsorted", TopDown = TRUE,
     xticklabels = "originalIndices", main = "entire profile set")
IC_ids_pwl <- chooseICavg(SPgroup, n = 4, nPWL = 4,
                          classifyPWLs = list(pwl_gtype = c("SH", "DH")),
                          classifyCRs = NULL)
plot(SPgroup[IC_ids_pwl], SortMethod = "unsorted", hardnessResidual = 0, TopDown = TRUE,
     xticklabels = IC_ids_pwl, main = "sample of profiles with rather many and distributed PWLs")

}
\seealso{
\link[sarp.snowprofile:findPWL]{sarp.snowprofile::findPWL}, \link{averageSP}
}
\author{
fherla
}
