% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplingin.R
\name{get_allocation}
\alias{get_allocation}
\title{Allocate Predetermined Allocations to Smaller Levels}
\usage{
get_allocation(data, n_alloc, group, pop_var = "jml", secondary = 0)
}
\arguments{
\item{data}{population tabulation dataframe}

\item{n_alloc}{total allocation dataframe}

\item{group}{group of allocation level to be obtained}

\item{pop_var}{population variable in data}

\item{secondary}{how many times the secondary sample compares to primary sample}
}
\value{
allocation at more detailed level
}
\description{
Allocate predetermined allocations to smaller levels using proportional allocation method
}
\examples{

library(samplingin)
library(magrittr)

contoh_alokasi = alokasi_dt \%>\%
   dplyr::select(-n_primary) \%>\%
   dplyr::mutate(nasional = 1)

alokasi_dt = get_allocation(
   data = contoh_alokasi
   , n_alloc = 100
   , group = c("nasional")
   , pop_var = "jml_kabkota"
)

}
