% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Multidiff.R
\name{multi_compare_merge}
\alias{multi_compare_merge}
\title{Combine multi_compare_objects}
\usage{
multi_compare_merge(multi_reg_object1, multi_reg_object2, p_adjust = FALSE)
}
\arguments{
\item{multi_reg_object1, multi_reg_object2}{Multireg objects that should be combined.}

\item{p_adjust}{A logical input or character string indicating an adjustment
method that isusable in the \code{method} parameter of
\code{\link[stats]{p.adjust}}. If set to TRUE the Bonferroni adjusted
p-values are used in inference.}
}
\value{
A combined \code{multi_reg_object} that can be used in plot functions to
create a visualization.
}
\description{
\code{multi_compare_merge} combines two \code{multi_compare_objects} to plot them together.
}
\examples{

## Get Data for comparison
card<-wooldridge::card

south <- card[card$south==1,]
north <- card[card$south==0,]
black <- card[card$black==1,]
white <- card[card$black==0,]

## use the function to plot the data
multi_data1 <- sampcompR::multi_compare(df = north, 
                                        bench = south,
                                        independent = c("age","fatheduc","motheduc","IQ"),
                                        dependent = c("educ"),
                                        family = "ols") 
                                     
multi_data2 <- sampcompR::multi_compare(df = black, 
                                        bench = white,
                                        independent = c("age","fatheduc","motheduc","IQ"),
                                        dependent = c("wage"),
                                        family = "ols") 
 ### merge two objects ###                                       
 merged_object<-multi_compare_merge(multi_data1,multi_data2)
 
 ### Plot the merged object ###
 plot_multi_compare("merged_object")                                       

}
