% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/midas_functions.R
\name{DAGM_long_run_vol}
\alias{DAGM_long_run_vol}
\title{DAGM (daily) long-run volatility (with skewness)}
\usage{
DAGM_long_run_vol(param, daily_ret, mv_m, K, lag_fun = "Beta")
}
\arguments{
\item{param}{Vector of estimated values. It must be a eight- or nine- dimensional vector. See the examples below.}

\item{daily_ret}{Daily returns, which must be an "xts" object.}

\item{mv_m}{MIDAS variable already transformed into a matrix, through \code{\link{mv_into_mat}} function.}

\item{K}{Number of (lagged) realizations of the MIDAS variable to consider.}

\item{lag_fun}{\strong{optional}. Lag function to use. Valid choices are "Beta" (by default) and "Almon",
for the Beta and Exponential Almon lag functions, respectively.}
}
\value{
The resulting vector is an "xts" object representing the conditional volatility.
}
\description{
Obtains the daily long-run volatility for the DAGM, with an asymmetric term linked to past negative returns.
For details, see \insertCite{amendola_candila_gallo:2019;textual}{rumidas}.
}
\examples{
\donttest{
est_val<-c(0.01,0.80,0.05,0,0.1,1.1,-0.3,1.1)
r_t<-sp500['/2010']
mv_m<-mv_into_mat(r_t,diff(indpro),K=12,"monthly")
head(DAGM_long_run_vol(est_val,r_t,mv_m,K=12))
}
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{mv_into_mat}}.
}
\keyword{internal}
