% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ruler-package.R
\docType{package}
\name{ruler-package}
\alias{ruler}
\alias{ruler-package}
\title{ruler: Rule Your Data}
\description{
\code{ruler} offers a set of tools for creating tidy data validation reports using
\href{https://dplyr.tidyverse.org}{dplyr} grammar of data manipulation. It
is designed to be flexible and extendable in terms of creating rules and
using their output.
}
\details{
The common workflow is:
\itemize{
\item Define dplyr-style \link[=rule-packs]{packs} of rules for basic data units (data,
group, column, row, cell) to obey.
\item \link[=expose]{Expose} some data to those rules. The result is the same data with
possibly created \link{exposure} attribute. Exposure contains
information \link[=packs_info]{about applied packs} and \link[=ruler-report]{tidy data validation report}.
\item Use data and exposure to perform some \link[=act_after_exposure]{actions}:
\link[=assert_any_breaker]{assert about rule breakers}, impute data, remove
outliers and so on.
}

To learn more about \code{ruler} browse vignettes with \code{browseVignettes(package = "ruler")}. The preferred order is:
\enumerate{
\item Design process and exposure format.
\item Rule packs.
\item Validation
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://echasnovski.github.io/ruler/}
  \item \url{https://github.com/echasnovski/ruler}
  \item Report bugs at \url{https://github.com/echasnovski/ruler/issues}
}

}
\author{
\strong{Maintainer}: Evgeni Chasnovski \email{evgeni.chasnovski@gmail.com} (\href{https://orcid.org/0000-0002-1617-4019}{ORCID})

}
