% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_params.R
\name{omega2omega}
\alias{omega2omega}
\alias{set_omegas_equal}
\title{Set process relaitve starting-point equal}
\usage{
omega2omega(model, names, keep_consts = FALSE)

set_omegas_equal(model, names, keep_consts = FALSE)
}
\arguments{
\item{model}{A list of the class \code{drtmpt_model}.}

\item{names}{Character vector giving the names of the processes for which the process relaitve starting-points should be equal. If
\code{length(names) = 1} then the corresponding process relaitve starting-point will be estimated (i.e., it will be set to NA)}

\item{keep_consts}{Can be one of the following
\itemize{
 \item logical value: \code{FALSE} (default) means none of the constants for \code{names} in the \code{model} will be kept; The relaitve starting-points of
   the reference process (i.e., first of \code{names} in alphabetical order) will be set to \code{NA} (i.e., will be estimated) and the others
   will be set to the name of the reference process (i.e., will be set to equal the reference process relative starting-point). \code{TRUE} means
   the constant of the reference process relaitve starting-point (if specified) is used for all other processes.
 \item numeric value: index for \code{names}. If 1, the constant of the first process in \code{names} (in original order defined by the user) is
   used for all other relaitve starting-points of the processes in \code{names}. If 2, the constant of the second process is used. And so on.
}}
}
\value{
A list of the class \code{drtmpt_model}.
}
\description{
Setting multiple process relaitve starting-points (omegas) equal. One of the process relaitve starting-points will be estimated and the
  other named relaitve starting-points will be set to equal the former. The equality can be removed by only using one name of a process.
}
\examples{
####################################################################################
# Detect-Guess variant of the Two-High Threshold model.
# The encoding and motor execution times are assumed to be equal for each category.
# The process relaitve starting-points for both detection processes ("do" and "dn")
# will be set equal.
####################################################################################

mdl_2HTM <- "
# targets
do+(1-do)*g
(1-do)*(1-g)

# lures
(1-dn)*g
dn+(1-dn)*(1-g)

# do: detect old; dn: detect new; g: guess
"

model <- to_drtmpt_model(mdl_file = mdl_2HTM)

## make do = dn
new_model <- omega2omega(model = model, names = c("do", "dn"))
new_model


## make do = dn
new_model <- set_omegas_equal(model = model, names = c("do", "dn"))
new_model
}
\seealso{
\code{\link{delta2delta}}, \code{\link{a2const}}, \code{\link{a2a}}, \code{\link{nu2const}}, \code{\link{nu2nu}}, and \code{\link{omega2const}}
}
\author{
Raphael Hartmann
}
