% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colby_constructors.R
\name{append_topleft}
\alias{append_topleft}
\title{Append a description to the 'top-left' materials for the layout}
\usage{
append_topleft(lyt, newlines)
}
\arguments{
\item{lyt}{(\code{PreDataTableLayouts})\cr layout object pre-data used for tabulation.}

\item{newlines}{(\code{character})\cr the new line(s) to be added to the materials.}
}
\value{
A \code{PreDataTableLayouts} object suitable for passing to further layouting functions, and to \code{\link[=build_table]{build_table()}}.
}
\description{
This function \emph{adds} \code{newlines} to the current set of "top-left materials".
}
\details{
Adds \code{newlines} to the set of strings representing the 'top-left' materials declared in the layout (the content
displayed to the left of the column labels when the resulting tables are printed).

Top-left material strings are stored and then displayed \emph{exactly as is}, no structure or indenting is applied to
them either when they are added or when they are displayed.
}
\note{
Currently, where in the construction of the layout this is called makes no difference, as it is independent of
the actual splitting keywords. This may change in the future.

This function is experimental, its name and the details of its behavior are subject to change in future versions.
}
\examples{
library(dplyr)

DM2 <- DM \%>\% mutate(RACE = factor(RACE), SEX = factor(SEX))

lyt <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  split_cols_by("SEX") \%>\%
  split_rows_by("RACE") \%>\%
  append_topleft("Ethnicity") \%>\%
  analyze("AGE") \%>\%
  append_topleft("  Age")

tbl <- build_table(lyt, DM2)
tbl

}
\seealso{
\code{\link[=top_left]{top_left()}}
}
