% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call_model_api.R
\name{get_valid_query}
\alias{get_valid_query}
\title{Get Valid Query Example}
\usage{
get_valid_query()
}
\value{
A list representing a valid query structure for v2.0.
}
\description{
Generates a sample query for prediction and validation for the v2.0 model.
This function provides an example query structure that can be modified for specific needs.
The sample query contains two example inputs: one for a cell line with CRISPR perturbation
and another for a primary tissue sample with disease information.
}
\examples{
# Get a sample query
query <- get_valid_query()

# Modify the query for a different modality
query$modality <- "bulk_rna-seq"

# Adjust the number of samples to generate
query$inputs[[1]]$num_samples <- 10
}
