% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rollup.R
\name{update_rollup}
\alias{update_rollup}
\title{Update a rollup from a single leaf vertex}
\usage{
update_rollup(tree, ds, vertex, update)
}
\arguments{
\item{tree}{\code{igraph} directed graph that is a valid single-rooted in-tree
and whose vertex names are keys from the data set}

\item{ds}{data set to be updated; can be any object}

\item{vertex}{The start vertex}

\item{update}{function called at each vertex as update(ds,
parent_key, child_keys)}
}
\value{
updated input data set
}
\description{
\code{update_rollup()} performs a minimal update of a data set assuming a single leaf element property
has changed. It performs updates along the path from that vertex to the root. There should be no difference
in the output from calling \code{rollup()} again. \code{update_rollup()} is perhaps more efficient and useful in an interactive context.
}
\examples{
update_rollup(wbs_tree, wbs_table, igraph::V(wbs_tree)["3.2"],
  update = function(d, p, c) {
    if (length(c) > 0)
      d[d$id == p, c("work", "budget")] <-
        apply(d[is.element(d$id, c), c("work", "budget")], 2, sum)
      d
  }
)

}
