% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npn_geoserver.R
\name{npn_get_layer_details}
\alias{npn_get_layer_details}
\title{Get Geospatial Data Layer Details}
\usage{
npn_get_layer_details()
}
\value{
A tibble containing all layer details as specified in function
description.
}
\description{
This function will return information about the various data layers available
via the NPN's geospatial web services. Specifically, this function will query
the NPN's GetCapabilities endpoint and parse the information on that page
about the layers. For each layer, this function will retrieve the layer name
(as to be specified elsewhere programmatically), the title (human readable),
the abstract, which describes the data in the layer, the dimension name and
dimension range for specifying specific date values from the layer.
}
\details{
Information about the layers can also be viewed at the getCapbilities page
directly: \url{https://geoserver.usanpn.org/geoserver/wms?request=GetCapabilities}
}
\examples{
\dontrun{
layers <- npn_get_layer_details()
}
}
