% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NuggetKMClass.R
\docType{class}
\name{NuggetKM-class}
\alias{NuggetKM-class}
\title{S4 class for NuggetKriging Models Extending the \code{"km"} Class}
\description{
This class is intended to be used either by using its
    own dedicated S4 methods or by using the S4 methods inherited
    from the \code{"km"} class of the \pkg{libKriging} package.
}
\section{Slots}{

\describe{
\item{\code{d,n,X,y,p,F}}{Number of (numeric) inputs, number of
observations, design matrix, response vector, number of trend
variables, trend matrix.}

\item{\code{trend.formula,trend.coef}}{Formula used for the trend, vector
\eqn{\hat{\boldsymbol{\beta}}}{betaHat} of estimated (or fixed)
trend coefficients with length \eqn{p}.}

\item{\code{covariance}}{A S4 object with class \code{"covTensorProduct"}
representing a covariance kernel.}

\item{\code{noise.flag,noise.var}}{Logical flag and numeric value for an
optional noise term.}

\item{\code{known.param}}{A character code indicating what parameters are
known.}

\item{\code{lower,upper}}{Bounds on the correlation range parameters.}

\item{\code{method,penalty,optim.method,control,gr,parinit}}{Objects
defining the estimation criterion, the optimization.}

\item{\code{T,M,z}}{Auxiliary variables (matrices and vectors) that can be
used in several computations.}

\item{\code{case}}{The possible concentration (a.k.a. profiling) of the
likelihood.}

\item{\code{param.estim}}{Logical. Is an estimation used?}

\item{\code{NuggetKriging}}{A copy of the \code{NuggetKriging} object used to create
the current \code{NuggetKM} object.}
}}

\seealso{
\code{\link[DiceKriging]{km-class}} in the
    \pkg{DiceKriging} package. The creator \code{\link{NuggetKM}}.
}
\author{
Yann Richet \email{yann.richet@irsn.fr}
}
