% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sources.R
\name{fractions}
\alias{fractions}
\title{Estimate a missing radiocarbon age from fractions}
\usage{
fractions(
  bulk_age,
  bulk_er,
  fractions_percC,
  fractions_weights,
  fractions_ages,
  fractions_errors,
  roundby = 1
)
}
\arguments{
\item{bulk_age}{The age of the bulk/entire sample}

\item{bulk_er}{The error of the age of the bulk/entire sample}

\item{fractions_percC}{The \%carbon contents of the fractions. If unknown, enter estimates (e.g., rep(1,4))}

\item{fractions_weights}{The weights of the fractions. The units are not important here as the weights are used to calculate the relative contributions of carbon within individual fractions to the entire sample.}

\item{fractions_ages}{The radiocarbon ages of the individual fractions. The fraction without a date should be entered as NA.}

\item{fractions_errors}{The errors of the radiocarbon ages of the individual fractions. The fraction without a date should be entered as NA.}

\item{roundby}{Rounding of the reported age}
}
\description{
Estimate a missing radiocarbon age from a sample which has C14 dates on both the bulk and on fractions, but where 1 sample was too small to be dated. This can be used in for example soils separated into size fractions, where one of the samples turns out to be too small to be dated. Requires to have the bulk age, the ages of the dated fractions, and the carbon contents and weights of all fractions.
}
\examples{
Cs <- c(.02, .05, .03, .04) # carbon contents of each fraction
wghts <- c(5, 4, 2, .5) # weights for all fractions, e.g., in mg
ages <- c(130, 130, 130, NA) # ages of all fractions. The unmeasured one is NA
errors <- c(10, 12, 10, NA) # errors, unmeasured is NA
fractions(150, 20, Cs, wghts, ages, errors) # assuming a bulk age of 150 +- 20 C14 BP
}
