% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realms.R
\name{calBPtoBCAD}
\alias{calBPtoBCAD}
\title{calculate BC/AD ages from cal BP ages}
\usage{
calBPtoBCAD(x, zero = TRUE)
}
\arguments{
\item{x}{The calBP age(s) to be translated into BC/AD ages.}

\item{zero}{Whether or not zero BC/AD should be included. Defaults to 0.}
}
\value{
The BC/AD age(s). BC ages are negative, AD ages are positive.
}
\description{
calculate BC/AD ages from cal BP ages
}
\details{
Turn cal BP ages into BC/AD (or BCE/CE). Negative ages indicate BC, positive ages AD. Since the Gregorian and Julian calendars do not include 0 BCAD (i.e., 31 December of 1 BC is followed by 1 January of AD 1), zero can be omitted. The years then go from 1 (AD) to -1 (i.e., 1 BC). Other calendars, such as the astronomical one, do include zero. The often-used BCE/CE ages are equivalent to BC/AD.
}
\examples{
 calBPtoBCAD(2024)
 calBPtoBCAD(1945:1955, zero=TRUE)
 calBPtoBCAD(1945:1955, zero=FALSE)
}
